VERSION 4.00
Begin VB.Form OSSMain 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   Caption         =   "VBossAPI Script Processing Example Application"
   ClientHeight    =   2490
   ClientLeft      =   1875
   ClientTop       =   2505
   ClientWidth     =   8220
   ForeColor       =   &H80000008&
   Height          =   2895
   Icon            =   "OSSMAIN.frx":0000
   Left            =   1815
   LinkTopic       =   "Form1"
   ScaleHeight     =   2490
   ScaleWidth      =   8220
   Top             =   2160
   Width           =   8340
   Begin VB.PictureBox PassOne 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   1
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   510
      Left            =   4440
      Picture         =   "OSSMAIN.frx":030A
      ScaleHeight     =   480
      ScaleWidth      =   480
      TabIndex        =   9
      Top             =   1710
      Visible         =   0   'False
      Width           =   510
   End
   Begin VB.PictureBox RunOff 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   1
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   510
      Left            =   5820
      Picture         =   "OSSMAIN.frx":0614
      ScaleHeight     =   480
      ScaleWidth      =   480
      TabIndex        =   8
      Top             =   1710
      Visible         =   0   'False
      Width           =   510
   End
   Begin VB.PictureBox RunOn 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   1
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   510
      Left            =   5160
      Picture         =   "OSSMAIN.frx":091E
      ScaleHeight     =   480
      ScaleWidth      =   480
      TabIndex        =   7
      Top             =   1710
      Visible         =   0   'False
      Width           =   510
   End
   Begin VB.ListBox Monitor 
      Appearance      =   0  'Flat
      BackColor       =   &H00008000&
      BeginProperty Font 
         name            =   "Small Fonts"
         charset         =   1
         weight          =   700
         size            =   6.75
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   3510
      TabIndex        =   1
      TabStop         =   0   'False
      Tag             =   "OL"
      Top             =   1020
      Width           =   1605
   End
   Begin VB.TextBox Editor 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      BeginProperty Font 
         name            =   "Courier New"
         charset         =   1
         weight          =   400
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   60
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      TabStop         =   0   'False
      Tag             =   "OL"
      Top             =   1200
      Width           =   3375
   End
   Begin Threed.SSCommand tbOption 
      Height          =   900
      Index           =   3
      Left            =   3600
      TabIndex        =   10
      TabStop         =   0   'False
      Top             =   135
      Width           =   915
      _version        =   65536
      _extentx        =   1614
      _extenty        =   1588
      _stockprops     =   78
      caption         =   "Keywords"
      font3d          =   3
      roundedcorners  =   0   'False
      picture         =   "OSSMAIN.frx":0C28
   End
   Begin Threed.SSCommand biAbout 
      Height          =   900
      Left            =   4560
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   135
      Width           =   825
      _version        =   65536
      _extentx        =   1455
      _extenty        =   1588
      _stockprops     =   78
      BeginProperty font {FB8F0823-0164-101B-84ED-08002B2EC713} 
         name            =   "MS Sans Serif"
         charset         =   1
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      font3d          =   3
      roundedcorners  =   0   'False
      picture         =   "OSSMAIN.frx":0F42
   End
   Begin Threed.SSCommand tbOption 
      Height          =   900
      Index           =   2
      Left            =   2520
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   135
      Width           =   930
      _version        =   65536
      _extentx        =   1640
      _extenty        =   1588
      _stockprops     =   78
      caption         =   "&Save"
      font3d          =   3
      roundedcorners  =   0   'False
      picture         =   "OSSMAIN.frx":125C
   End
   Begin Threed.SSCommand tbOption 
      Height          =   900
      Index           =   1
      Left            =   1740
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   135
      Width           =   795
      _version        =   65536
      _extentx        =   1402
      _extenty        =   1588
      _stockprops     =   78
      caption         =   "&Load"
      font3d          =   3
      roundedcorners  =   0   'False
      picture         =   "OSSMAIN.frx":1576
   End
   Begin Threed.SSCommand tbOption 
      Height          =   900
      Index           =   0
      Left            =   900
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   135
      Width           =   855
      _version        =   65536
      _extentx        =   1508
      _extenty        =   1588
      _stockprops     =   78
      caption         =   "&RUN"
      font3d          =   3
      roundedcorners  =   0   'False
      picture         =   "OSSMAIN.frx":1890
   End
   Begin Threed.SSCommand biQuit 
      Height          =   900
      Left            =   120
      TabIndex        =   2
      TabStop         =   0   'False
      Top             =   135
      Width           =   795
      _version        =   65536
      _extentx        =   1402
      _extenty        =   1588
      _stockprops     =   78
      caption         =   "&Exit"
      font3d          =   3
      roundedcorners  =   0   'False
      picture         =   "OSSMAIN.frx":1BAA
   End
   Begin MSComDlg.CommonDialog CD 
      Left            =   5760
      Top             =   990
      _version        =   65536
      _extentx        =   847
      _extenty        =   847
      _stockprops     =   0
   End
End
Attribute VB_Name = "OSSMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

'
' Tool Bar command indexes
'
Const TB_START = 0      ' start program
Const TB_LOAD = 1       ' load program
Const TB_SAVE = 2       ' save program
Const TB_KEYS = 3       ' display keywords

Dim EditorChanged As Integer
Dim MyScript As Integer

Private Sub biAbout_Click()
    
    AboutBox.Show 1
    Editor.SetFocus

End Sub

Private Sub biQuit_Click()

    Unload Me

End Sub

Private Sub Editor_Change()

    EditorChanged = True

End Sub

Private Sub Form_Activate()
Dim rc As Integer
Static once As Integer

    If Not once Then
        
        rc = SendMessage(Editor.hWnd, EM_SETTABSTOPS, 1, 16&)
        once = True
    
    End If

End Sub

Private Sub Form_Load()
Dim rc As Integer

    ChDir App.Path

    Me.Height = Screen.Height - 240
    Me.Width = Screen.Width - 240
    CenterForm Me, 0, 0

    Me.Show
    Editor.SetFocus
    
    DoEvents

    '
    ' THIS STEP IS NOW REQUIRED - CREATES A NEW INSTANCE
    ' SEE UNLOAD EVENT FOR LAST STEP
    '
    MyScript = CreateScrObject()
    
    '
    '  Enter your UserID and RegistrationKey here to disable
    '  the shareware panels.
    '
    rc = RegisterVBossAPI("User-ID", "Registration-Key")
    
    ' this is just an example of SetDelimiters
    ' it is not strictly required in this example
    SetDelimiters DefTokenDelims()
    SetOperators NT_Operators() + "."
    SetDefaultKeywords
    EditorChanged = False

End Sub

Private Sub Form_Paint()

    Outlines Me

End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
Const ID_YES = 6
Const ID_CANCEL = 2
Dim rc As Integer

    If EditorChanged Then

        rc = MsgBox("Program changed, Save before Exit?", MB_YESNOCANCEL + MB_ICONQUESTION, "Program Changed")

        If rc = ID_CANCEL Then
            
            Cancel = True
            Editor.SetFocus

        ElseIf rc = ID_YES Then

            SaveFile Editor

        End If

    End If

End Sub

Private Sub Form_Resize()

Dim WorkTop     As Integer
Dim WorkLeft    As Integer
Dim WorkRight   As Integer
Dim WorkBottom  As Integer
    
    On Error Resume Next

    WorkTop = biQuit.Height + 240
    WorkLeft = 120
    WorkRight = ScaleWidth - 120
    WorkBottom = ScaleHeight - (WorkTop + 120)

    Editor.Left = WorkLeft
    Editor.Height = WorkBottom
    Editor.Top = WorkTop
    Editor.Width = WorkLeft + (WorkRight * 0.6)

    Monitor.Top = WorkTop
    Monitor.Height = WorkBottom
    Monitor.Left = (WorkLeft * 2) + Editor.Width
    Monitor.Width = WorkRight - Monitor.Left

End Sub

Private Sub Form_Unload(Cancel As Integer)

    DestroyScrObject MyScript

End Sub

'
' PROCEDURE OpenFile <textbox>
'
'   Using the Common Dialog DLL, prompt for and open a program
'   located in the TextBox control passed as <program>
'
Private Sub ReadFile(program As TextBox)

Dim RF_TITLE As String   ' dialog title
Dim file        As Integer          ' file I/O handle
Dim Filename    As String           ' filename
Dim buf         As String           ' the program buffer

    On Error GoTo RF_Cancel

    file = FreeFile

    RF_TITLE = "Load Program"
    cd.CancelError = True
    cd.DefaultExt = "prg"
    cd.DialogTitle = RF_TITLE
    cd.Filter = "Source (*.prg)|*.prg|Text (*.txt)|*.txt|Any (*.*)|*.*"
    cd.InitDir = App.Path
    cd.Flags = CDF_OPEN

    cd.Action = CD_OPEN
    Filename = cd.Filename
    
    buf = Space(FileLen(Filename))
    Open Filename For Binary Access Read As file

    Get file, , buf
    Close file

    program.Text = buf
    buf = ""

    EditorChanged = False

' [Exit Sub]

GoTo RF_Exit

RF_Cancel:

    If Not (Err = CDERR_CANCEL) Then
        
        MsgBox "Cancelled. An error has ocurred!" & CRLF & "[" & Err & "]" & Error$, MB_ICONSTOP, RF_TITLE

    End If
    
    Resume RF_Exit

RF_Exit:


End Sub

'
' PROCEDURE SaveFile <textbox>
'
'   Using the Common Dialog DLL, prompt for and save program
'   located in the TextBox control passed as <program>
'
Private Sub SaveFile(program As TextBox)

Dim SF_TITLE As String   ' dialog title
Dim file        As Integer          ' file I/O handle
Dim Filename    As String           ' filename
Dim buf         As String           ' the program buffer

    On Error GoTo SF_Cancel

    file = FreeFile
    buf = Trim$(program.Text)

    SF_TITLE = "Save Program As"
    cd.CancelError = True
    cd.DefaultExt = "prg"
    cd.DialogTitle = SF_TITLE
    cd.Filter = "Source (*.prg)|*.prg|Text (*.txt)|*.txt|Any (*.*)|*.*"
    cd.InitDir = App.Path
    cd.Flags = CDF_SAVE

    cd.Action = CD_SAVEAS
    Filename = cd.Filename
    
    On Error Resume Next
    Kill Filename
    On Error GoTo SF_Cancel

    Open Filename For Binary Access Write As file
    Put file, , buf
    Close file

    EditorChanged = False

' [Exit Sub]

GoTo SF_Exit

SF_Cancel:

    If Err = CDERR_CANCEL Then
        
        MsgBox "Cancelled. Program not saved.", MB_OK + MB_ICONEXCLAMATION, SF_TITLE

    Else

        MsgBox "Cancelled. An error has ocurred!" & CRLF & " [" & Err & "] " & Error$, MB_ICONSTOP, SF_TITLE

    End If
    
    Resume SF_Exit

SF_Exit:  End Sub

'
' ToolBar option buttons
'
Private Sub tbOption_Click(Index As Integer)

  Dim rc As Integer
    
    Select Case Index

        '
        '  Run
        '
        Case TB_START

            tbOption(TB_START).Picture = OSSMain.PassOne
            DoEvents
            
            
            ' initialize variables for first pass (Label search)
            
            ixLabel = 0
            ReDim Labels(24)
            ZapVariables

            FirstPass = True
            
            If Interpret(Editor) Then

                '
                ' no glaring syntax errors, so preset the labels
                '
                PresetLabels
                ReturnStack(0) = 0
                UntilStack(0) = 0
                NextStack(0) = 0

                tbOption(TB_START).Picture = OSSMain.RunOn

                '
                '  Now execute the script
                '
                FirstPass = False       ' second pass
                rc = Interpret(Editor)

            End If
        
            tbOption(TB_START).Picture = OSSMain.RunOff
        
        Case TB_LOAD

            ReadFile Editor

        Case TB_SAVE

            SaveFile Editor

        Case TB_KEYS

            KeyForm.Show 1

    End Select

    Editor.SetFocus

End Sub

